clear;
close all;

load ekg.mat
ekg=ekg-mean(ekg);

fp=960;
f=linspace(0,fp,3600);
t=linspace(0,(3600/fp),3600);

% Projekt filtra ellip
Rp=0.1;
Rs=50;
wp=[45 75]/(fp/2);
ws=[50 65]/(fp/2);
[N,wn]=ellipord(wp,ws,Rp,Rs);
[b,a]=ellip(N,Rp,Rs,wn,'stop');

figure(1);
freqz(b,a,512,fp);

% Filtracja sygnau
sf=filter(b,a,ekg);

figure(2);
hold on
plot(t,ekg);
plot(t(100:3600),sf(100:3600),'r');
grid;
hold off
title('Sygnal przed i po filtracji');
xlabel('Czas [s]');ylabel('Amplituda');


w=fft(ekg);
wlin=abs(w);
wlog=20*log10(wlin/max(wlin));
wf=fft(sf);
wflin=abs(wf);
wflog=20*log10(wflin/max(wflin));

figure(3);
subplot(211);
plot(f(1:1800),wlog(1:1800));
ylim([-100 10]);
grid;
title('Widmo sygnalu przed filtracja');
xlabel('Czestotliwosc [Hz]');ylabel('Amplituda');
subplot(212);
plot(f(1:1800),wflog(1:1800));
ylim([-100 10]);
grid;
title('Widmo sygnalu po filtracji');
xlabel('Czestotliwosc [Hz]');ylabel('Amplituda');